CREATE OR REPLACE FUNCTION addColumn() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
    
	IF EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'pdv_cupom_nao_fiscal' and column_name='tp_cupom_nao_fiscal') THEN 
		
		ALTER TABLE pdv_cupom_nao_fiscal ALTER COLUMN tp_cupom_nao_fiscal type numeric(2);

	END IF; 

END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION addColumn() OWNER TO postgres; 


DROP VIEW IF EXISTS v_cupomnaofiscal;

DROP VIEW IF EXISTS nada;

DROP VIEW IF EXISTS v_movimento_por_ecf_pdv_outros_documentos_r06;

DROP VIEW IF EXISTS v_pdv_consld_vd;

DROP VIEW IF EXISTS v_pdv_consld_vd_nfce;

DROP VIEW IF EXISTS v_pdv_consld_vd_teste;

DROP VIEW IF EXISTS v_pdv_meios_pgto_fecha_caixa;

DROP VIEW IF EXISTS v_pdv_tef_pendentes;

DROP VIEW IF EXISTS v_recebimento_crediario;

SELECT addColumn(); 

DROP FUNCTION addColumn();


CREATE OR REPLACE FUNCTION addView() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
	
	IF EXISTS (SELECT 1 FROM information_schema.columns 
					WHERE table_name= 'v_cupomnaofiscal') THEN 
		DROP VIEW v_cupomnaofiscal;
		RAISE NOTICE 'v_cupomnaofiscal Dropada.';
	END IF;
	
	CREATE OR REPLACE VIEW public.v_cupomnaofiscal
	AS SELECT cupom.cd_emp,
		cupom.cd_filial,
		cupom.cd_cx,
		cupom.dt_cupom,
		cupom.dt_cad,
		cupom.hr_cupom,
		cupom.tp_cupom_nao_fiscal AS tp_cupom,
		cupom.cd_mov,
		cupom.cd_ctr,
		cupom.nr_coo,
		cupom.st_cupom,
		cupom.cont_cupom_fisc AS contador_cupom_fiscal,
		cupom.cd_mov AS codigo_movimento,
		filial.cgc AS cgc_filial,
		filial.nm_fant AS nm_filial,
		cupom.vlr_to_cupom AS vlr_tot_cupom,
		cupom.vlr_dinh,
		cupom.vlr_cartao,
		cupom.vlr_chqs_a_vista + cupom.vlr_chqs_a_prz AS vlr_chqs,
		cupom.cd_oper_cel,
		cupom.nr_cel_recarga,
		cupom.vlr_recarga_cel,
		cupom.nm_oper_cel,
		cupom.nr_serie_imp AS nr_serie_ecf,
		cupom.vs_pdv AS versao_pdv,
		cupom.vs_pdv_rc AS versao_pdv_rc,
		operador.cd_usu AS cd_operador,
		operador.nm_usu AS nm_operador,
		NULLIF(COALESCE(cupom.vlr_dinh, 0::numeric) <> 0::numeric, false) AS contem_dinheiro,
		NULLIF(COALESCE(cupom.vlr_recarga_cel, 0::numeric) <> 0::numeric, false) AS contem_recarga_cel,
		NULLIF(cupom.st_cupom <> 0::numeric, false) AS is_cancelado,
		COALESCE(cupom.flag_consolidado, 0) AS flag_consolidado,
		cupom.tp_cupom_nao_fiscal = 0::numeric AS is_fatura,
		cupom.tp_cupom_nao_fiscal = 1::numeric AS is_doacao,
		cupom.tp_cupom_nao_fiscal = 2::numeric AS is_diversos,
		cupom.tp_cupom_nao_fiscal = 3::numeric AS is_recarga,
		cupom.cd_ctr AS doacao_id,
		entidade.cd_entid AS doacao_favor_id,
		entidade.nm_entid AS doacao_favor_nome,
		COALESCE(fatura.cd_ctr_pgto, parcela.cd_ctr_pgto) AS fatura_rec_id,
		fatura.cd_rc_deb AS fatura_id,
		fatura.vlr_sld_dp AS fatura_vlr,
		fatura.vlr_sld_dp AS fatura_vlr_sld,
		fatura.vlr_min_pgto AS fatura_vlr_min,
		fatura.vlr_pago AS fatura_vlr_cred,
		parcela.cd_ctr_parc AS parcela_id,
		parcela.vlr_parc AS parcela_vlr,
		parcela.vlr_pago AS parcela_vlr_cred,
		diversos.dt_vencto AS diversos_venc,
			CASE
				WHEN diversos.cd_recb_pdv <> 0 THEN diversos.cd_recb_pdv
				ELSE 0::bigint
			END AS diversos_id,
		diversos.ident_recb_pdv AS diversos_codigo,
		0 AS st_vd,
		cupom.hash_protocolo,
		cupom.st_pend_estorno,
		fatura.st_paga AS fatura_st_paga,
		fatura.tp_pgto_offline AS fatura_offline,
		fatura.vlrjuros AS fatura_vlr_juro,
		fatura.vlrdesconto AS fatura_vlr_desc,
		fatura.nrfatura AS fatura_nr_fatura,
		fatura.dt_vencto AS fatura_dt_vencto,
		parcela.st_paga AS parcela_st_paga,
		parcela.tp_pgto_offline AS parcela_offline,
		COALESCE(cupom.obs_cupom, ''::character varying) AS obs_cupom,
		COALESCE(cupom.cd_mt_sangria, 0::numeric) AS "coalesce",
		cupom.cd_mt_sangria,
		cupom.cd_cli,
		coalesce(cupom.cd_vd_doacao, 0) as cd_vd
	   FROM pdv_cupom_nao_fiscal cupom
		 LEFT JOIN prc_filial filial ON cupom.cd_emp = filial.cd_emp AND cupom.cd_filial = filial.cd_filial
		 LEFT JOIN pdv_cupom_nao_fiscal_rec_fatura fatura ON cupom.cd_emp = fatura.cd_emp AND cupom.cd_filial = fatura.cd_filial AND cupom.cd_cx = fatura.cd_cx AND cupom.cd_ctr = fatura.cd_ctr AND fatura.st_paga = 1::numeric
		 LEFT JOIN pdv_cupom_nao_fiscal_rec_parc_cred parcela ON cupom.cd_emp = parcela.cd_emp AND cupom.cd_filial = parcela.cd_filial AND cupom.cd_cx = parcela.cd_cx AND cupom.cd_ctr = parcela.cd_ctr
		 LEFT JOIN pdv_cupom_nao_fiscal_est_recb_pdv diversos ON cupom.cd_emp = diversos.cd_emp AND cupom.cd_filial = diversos.cd_filial AND cupom.cd_cx = diversos.cd_cx AND cupom.cd_ctr = diversos.cd_ctr
		 LEFT JOIN pdv_cupom_nao_fiscal_est_entid_doacao doacao ON cupom.cd_emp = doacao.cd_emp AND cupom.cd_filial = doacao.cd_filial AND cupom.cd_cx = doacao.cd_cx AND cupom.cd_ctr = doacao.cd_ctr
		 LEFT JOIN est_entidade_doacao entidade ON doacao.cd_emp = entidade.cd_emp AND doacao.cd_entid = entidade.cd_entid
		 LEFT JOIN glb_usu operador ON cupom.cd_usu = operador.cd_usu
	  WHERE cupom.st_cupom >= 0::numeric AND NOT (cupom.st_cupom = 2::numeric AND NOT cupom.tp_cupom_nao_fiscal = 0::numeric);

	-- Permissions

	ALTER TABLE public.v_cupomnaofiscal OWNER TO postgres;
	
	RAISE NOTICE 'v_cupomnaofiscal Recriada.';

END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION addView() OWNER TO postgres; 
SELECT addView(); 
DROP FUNCTION addView();



CREATE OR REPLACE FUNCTION addView() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
	
	IF EXISTS (SELECT 1 FROM information_schema.columns 
					WHERE table_name= 'nada') THEN 
		DROP VIEW nada;
		RAISE NOTICE 'nada';
	END IF;
	
	CREATE OR REPLACE VIEW public.nada
	AS SELECT vd.cd_emp,
		vd.cd_filial,
		vd.dt_vd,
		vd.cd_cx,
		vd.nr_ecf,
		vd.vlr_liq_vd,
		( SELECT COALESCE(sum(it.vlr_tot_it - it.vlr_desc_tot_rat), 0::numeric) AS "coalesce"
			   FROM pdv_vd_it it
			  WHERE vd.cd_emp = it.cd_emp AND vd.cd_filial = it.cd_filial AND vd.cd_vd = it.cd_vd AND it.tipo_imposto = 0::numeric AND it.st_it = 1::numeric) AS vndprod,
		( SELECT COALESCE(sum(it.vlr_tot_it - it.vlr_desc_tot_rat), 0::numeric) AS "coalesce"
			   FROM pdv_vd_it it
			  WHERE vd.cd_emp = it.cd_emp AND vd.cd_filial = it.cd_filial AND vd.cd_vd = it.cd_vd AND it.tipo_imposto = 1::numeric AND it.st_it = 1::numeric) AS vndserv,
		0.00 AS naofiscal,
		0 AS tipovenda
	   FROM pdv_vd vd
	  WHERE vd.st_vd = 0::numeric
	UNION ALL
	 SELECT pdv_cupom_nao_fiscal.cd_emp,
		pdv_cupom_nao_fiscal.cd_filial,
		pdv_cupom_nao_fiscal.dt_cupom AS dt_vd,
		pdv_cupom_nao_fiscal.cd_cx,
		pdv_cupom_nao_fiscal.nr_coo AS nr_ecf,
		0 AS vlr_liq_vd,
		0 AS vndprod,
		0 AS vndserv,
		pdv_cupom_nao_fiscal.vlr_to_cupom AS naofiscal,
		1 AS tipovenda
	   FROM pdv_cupom_nao_fiscal
	  WHERE (pdv_cupom_nao_fiscal.tp_cupom_nao_fiscal = ANY (ARRAY[0::numeric, 1::numeric, 2::numeric, 3::numeric])) AND pdv_cupom_nao_fiscal.st_cupom <> 2::numeric;

	-- Permissions

	ALTER TABLE public.nada OWNER TO postgres;
	
	RAISE NOTICE 'nada Recriada.';

END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION addView() OWNER TO postgres; 
SELECT addView(); 
DROP FUNCTION addView();


CREATE OR REPLACE FUNCTION addView() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
	
	IF EXISTS (SELECT 1 FROM information_schema.columns 
					WHERE table_name= 'v_movimento_por_ecf_pdv_outros_documentos_r06') THEN 
		DROP VIEW v_movimento_por_ecf_pdv_outros_documentos_r06;
		RAISE NOTICE 'v_movimento_por_ecf_pdv_outros_documentos_r06';
	END IF;
	
	CREATE OR REPLACE VIEW public.v_movimento_por_ecf_pdv_outros_documentos_r06
	AS SELECT pdv_outros_documentos.cd_emp,
		pdv_outros_documentos.cd_filial,
		pdv_outros_documentos.cd_cx,
		pdv_outros_documentos.cd_ctr,
		pdv_outros_documentos.cont_ordem_operacao,
		pdv_outros_documentos.cont_geral_n_fisc,
		pdv_outros_documentos.cont_geral_rel_gerencial,
		pdv_outros_documentos.cont_compr_deb_cred,
		pdv_outros_documentos.denominacao_doc_fiscal,
		pdv_outros_documentos.dt_final_emis,
		pdv_outros_documentos.hr_emis,
		( SELECT pdv_cx.modelo_ecf
			   FROM pdv_cx
			  WHERE pdv_outros_documentos.cd_emp = pdv_cx.cd_emp AND pdv_outros_documentos.cd_filial = pdv_cx.cd_filial AND pdv_outros_documentos.cd_cx = pdv_cx.cd_cx) AS modelo_ecf,
			CASE
				WHEN COALESCE(pdv_outros_documentos.reg_alterado::boolean, false) = true THEN 1
				ELSE 0
			END AS reg_alterado,
		pdv_outros_documentos.nr_serie_imp
	   FROM pdv_outros_documentos
	UNION ALL
	 SELECT pdv_outros_documentos.cd_emp,
		pdv_outros_documentos.cd_filial,
		pdv_outros_documentos.cd_cx,
		pdv_outros_documentos.cd_ctr,
		pdv_outros_documentos.nr_coo AS cont_ordem_operacao,
		pdv_outros_documentos.cont_geral_n_fisc,
		0 AS cont_geral_rel_gerencial,
		0 AS cont_compr_deb_cred,
		'CN'::character varying AS denominacao_doc_fiscal,
		pdv_outros_documentos.dt_cupom AS dt_final_emis,
		pdv_outros_documentos.dt_cupom AS hr_emis,
		( SELECT pdv_cx.modelo_ecf
			   FROM pdv_cx
			  WHERE pdv_outros_documentos.cd_emp = pdv_cx.cd_emp AND pdv_outros_documentos.cd_filial = pdv_cx.cd_filial AND pdv_outros_documentos.cd_cx = pdv_cx.cd_cx) AS modelo_ecf,
			CASE
				WHEN COALESCE(pdv_outros_documentos.reg_alterado::boolean, false) = true THEN 1
				ELSE 0
			END AS reg_alterado,
		pdv_outros_documentos.nr_serie_imp
	   FROM pdv_cupom_nao_fiscal pdv_outros_documentos
	  WHERE (pdv_outros_documentos.tp_cupom_nao_fiscal = ANY (ARRAY[4::numeric, 5::numeric])) AND (pdv_outros_documentos.tp_cupom_nao_fiscal <> ALL (ARRAY[4::numeric, 5::numeric]));

	-- Permissions

	ALTER TABLE public.v_movimento_por_ecf_pdv_outros_documentos_r06 OWNER TO postgres;
	
	RAISE NOTICE 'v_movimento_por_ecf_pdv_outros_documentos_r06 Recriada.';

END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION addView() OWNER TO postgres; 
SELECT addView(); 
DROP FUNCTION addView();

CREATE OR REPLACE FUNCTION addView() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
	
	IF EXISTS (SELECT 1 FROM information_schema.columns 
					WHERE table_name= 'v_pdv_consld_vd') THEN 
		DROP VIEW v_pdv_consld_vd;
		RAISE NOTICE 'v_pdv_consld_vd';
	END IF;
	
	CREATE OR REPLACE VIEW public.v_pdv_consld_vd
	AS SELECT venda.cd_emp,
		venda.cd_filial,
		venda.dt_vd,
		venda.cd_cx,
		sum(venda.nr_coo_ini) AS nr_coo_ini,
		sum(venda.nr_coo_fin) AS nr_coo_fin,
		sum(venda.vl_vd_prod) AS vl_vd_prod,
		sum(venda.vl_vd_serv) AS vl_vd_serv,
		sum(venda.vl_vd_nfiscal) AS vl_vd_nfiscal
	   FROM ( SELECT consolid.cd_emp,
				consolid.cd_filial,
				consolid.dt_vd,
				consolid.cd_cx,
				( SELECT COALESCE(min(v.nr_ecf), 0::numeric) AS "coalesce"
					   FROM pdv_vd v
					  WHERE v.cd_emp = consolid.cd_emp AND v.cd_filial = consolid.cd_filial AND v.cd_cx = consolid.cd_cx AND v.dt_vd = consolid.dt_vd AND consolid.tipovenda = 0) AS nr_coo_ini,
				( SELECT COALESCE(max(v.nr_ecf), 0::numeric) AS "coalesce"
					   FROM pdv_vd v
					  WHERE v.cd_emp = consolid.cd_emp AND v.cd_filial = consolid.cd_filial AND v.cd_cx = consolid.cd_cx AND v.dt_vd = consolid.dt_vd AND consolid.tipovenda = 0) AS nr_coo_fin,
				sum(consolid.vndprod) AS vl_vd_prod,
				sum(consolid.vndserv) AS vl_vd_serv,
				sum(consolid.naofiscal) AS vl_vd_nfiscal
			   FROM ( SELECT vd.cd_emp,
						vd.cd_filial,
						vd.dt_vd,
						vd.cd_cx,
						vd.nr_ecf,
						vd.vlr_liq_vd,
						( SELECT COALESCE(sum(it.vlr_tot_it - it.vlr_desc_tot_rat), 0::numeric) AS "coalesce"
							   FROM pdv_vd_it it
							  WHERE vd.cd_emp = it.cd_emp AND vd.cd_filial = it.cd_filial AND vd.cd_vd = it.cd_vd AND it.tipo_imposto = 0::numeric AND it.st_it = 1::numeric) AS vndprod,
						( SELECT COALESCE(sum(it.vlr_tot_it - it.vlr_desc_tot_rat), 0::numeric) AS "coalesce"
							   FROM pdv_vd_it it
							  WHERE vd.cd_emp = it.cd_emp AND vd.cd_filial = it.cd_filial AND vd.cd_vd = it.cd_vd AND it.tipo_imposto = 1::numeric AND it.st_it = 1::numeric) AS vndserv,
						0.00 AS naofiscal,
						0 AS tipovenda
					   FROM pdv_vd vd
					  WHERE vd.st_vd = 0::numeric
					UNION ALL
					 SELECT pdv_cupom_nao_fiscal.cd_emp,
						pdv_cupom_nao_fiscal.cd_filial,
						pdv_cupom_nao_fiscal.dt_cupom,
						pdv_cupom_nao_fiscal.cd_cx,
						pdv_cupom_nao_fiscal.nr_coo,
						0 AS vlr_liq_vd,
						0 AS vndprod,
						0 AS vndserv,
						pdv_cupom_nao_fiscal.vlr_to_cupom AS naofiscal,
						1 AS tipovenda
					   FROM pdv_cupom_nao_fiscal
					  WHERE (pdv_cupom_nao_fiscal.tp_cupom_nao_fiscal = ANY (ARRAY[0::numeric, 1::numeric, 2::numeric, 3::numeric])) AND pdv_cupom_nao_fiscal.st_cupom <> 2::numeric) consolid
			  GROUP BY consolid.cd_emp, consolid.cd_filial, consolid.dt_vd, consolid.cd_cx, consolid.tipovenda) venda
	  GROUP BY venda.cd_emp, venda.cd_filial, venda.dt_vd, venda.cd_cx;

	-- Permissions

	ALTER TABLE public.v_pdv_consld_vd OWNER TO postgres;
	
	RAISE NOTICE 'v_pdv_consld_vd Recriada.';

END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION addView() OWNER TO postgres; 
SELECT addView(); 
DROP FUNCTION addView();


CREATE OR REPLACE FUNCTION addView() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
	
	IF EXISTS (SELECT 1 FROM information_schema.columns 
					WHERE table_name= 'v_pdv_consld_vd_nfce') THEN 
		DROP VIEW v_pdv_consld_vd_nfce;
		RAISE NOTICE 'v_pdv_consld_vd_nfce';
	END IF;
	
	CREATE OR REPLACE VIEW public.v_pdv_consld_vd_nfce AS 
 SELECT venda.cd_emp,
    venda.cd_filial,
    venda.dt_vd,
    venda.cd_cx,
    sum(venda.nr_coo_ini) AS nr_coo_ini,
    sum(venda.nr_coo_fin) AS nr_coo_fin,
    sum(venda.vl_vd_prod) AS vl_vd_prod,
    sum(venda.vl_vd_serv) AS vl_vd_serv,
    sum(venda.vl_vd_nfiscal) AS vl_vd_nfiscal
   FROM ( SELECT consolid.cd_emp,
            consolid.cd_filial,
            consolid.dt_vd,
            consolid.cd_cx,
            ( SELECT COALESCE(min(v.nr_ecf), 0::numeric) AS "coalesce"
                   FROM pdv_vd v
                  WHERE v.cd_emp = consolid.cd_emp AND v.cd_filial = consolid.cd_filial AND v.cd_cx = consolid.cd_cx AND v.dt_vd = consolid.dt_vd AND consolid.tipovenda = 0) AS nr_coo_ini,
            ( SELECT COALESCE(max(v.nr_ecf), 0::numeric) AS "coalesce"
                   FROM pdv_vd v
                  WHERE v.cd_emp = consolid.cd_emp AND v.cd_filial = consolid.cd_filial AND v.cd_cx = consolid.cd_cx AND v.dt_vd = consolid.dt_vd AND consolid.tipovenda = 0) AS nr_coo_fin,
            sum(consolid.vndprod) AS vl_vd_prod,
            sum(consolid.vndserv) AS vl_vd_serv,
            sum(consolid.naofiscal) AS vl_vd_nfiscal
           FROM ( SELECT vd.cd_emp,
                    vd.cd_filial,
                    vd.dt_vd,
                    vd.cd_cx,
                    vd.nr_ecf,
                    vd.vlr_liq_vd,
                    ( SELECT COALESCE(sum(it.vlr_liq_it - it.vlr_desc_tot_rat), 0::numeric) AS "coalesce"
                           FROM pdv_vd_it it
                          WHERE vd.cd_emp = it.cd_emp AND vd.cd_filial = it.cd_filial AND vd.cd_vd = it.cd_vd AND it.tipo_imposto = 0::numeric AND it.st_it = 1::numeric) AS vndprod,
                    ( SELECT COALESCE(sum(it.vlr_liq_it - it.vlr_desc_tot_rat), 0::numeric) AS "coalesce"
                           FROM pdv_vd_it it
                          WHERE vd.cd_emp = it.cd_emp AND vd.cd_filial = it.cd_filial AND vd.cd_vd = it.cd_vd AND it.tipo_imposto = 1::numeric AND it.st_it = 1::numeric) AS vndserv,
                    0.00 AS naofiscal,
                    0 AS tipovenda
                   FROM pdv_vd vd
                  WHERE vd.st_vd = 0::numeric
                UNION ALL
                 SELECT pdv_cupom_nao_fiscal.cd_emp,
                    pdv_cupom_nao_fiscal.cd_filial,
                    pdv_cupom_nao_fiscal.dt_cupom,
                    pdv_cupom_nao_fiscal.cd_cx,
                    pdv_cupom_nao_fiscal.nr_coo,
                    0 AS vlr_liq_vd,
                    0 AS vndprod,
                    0 AS vndserv,
                    pdv_cupom_nao_fiscal.vlr_to_cupom AS naofiscal,
                    1 AS tipovenda
                   FROM pdv_cupom_nao_fiscal
                  WHERE (pdv_cupom_nao_fiscal.tp_cupom_nao_fiscal = ANY (ARRAY[0::numeric, 1::numeric, 2::numeric, 3::numeric])) AND pdv_cupom_nao_fiscal.st_cupom = 1::numeric) consolid
          GROUP BY consolid.cd_emp, consolid.cd_filial, consolid.dt_vd, consolid.cd_cx, consolid.tipovenda) venda
  GROUP BY venda.cd_emp, venda.cd_filial, venda.dt_vd, venda.cd_cx;

	-- Permissions

	ALTER TABLE public.v_pdv_consld_vd_nfce OWNER TO postgres;
	
	RAISE NOTICE 'v_pdv_consld_vd_nfce Recriada.';

END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION addView() OWNER TO postgres; 
SELECT addView(); 
DROP FUNCTION addView();


CREATE OR REPLACE FUNCTION addView() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
	
	IF EXISTS (SELECT 1 FROM information_schema.columns 
					WHERE table_name= 'v_pdv_meios_pgto_fecha_caixa') THEN 
		DROP VIEW v_pdv_meios_pgto_fecha_caixa;
		RAISE NOTICE 'v_pdv_meios_pgto_fecha_caixa';
	END IF;
	
	CREATE OR REPLACE VIEW public.v_pdv_meios_pgto_fecha_caixa
	AS SELECT rstemp.cd_emp,
		rstemp.cd_filial,
		rstemp.cd_cx,
		rstemp.cd_mov,
		rstemp.dt_vd,
		rstemp.id_documento,
		rstemp.ds_meio_pgto,
		rstemp.cod_bandeira,
		rstemp.cod_modalidade,
		rstemp.cd_adm_cartao,
		sum(rstemp.vlr_pag) AS vlr_pag,
		rstemp.tp_forma_pgto
	   FROM ( SELECT pdv_vd.cd_emp,
				pdv_vd.cd_filial,
				pdv_vd.cd_cx,
				pdv_vd.cd_vd,
				pdv_vd.cd_mov,
				pdv_vd.dt_vd,
				'CF'::text AS id_documento,
				'DINHEIRO'::text AS ds_meio_pgto,
				pdv_vd.vlr_dinh AS vlr_pag,
				0 AS cod_bandeira,
				''::text AS cod_modalidade,
				0 AS cd_adm_cartao,
				0 AS tp_forma_pgto
			   FROM pdv_vd
			  WHERE pdv_vd.vlr_dinh > 0::numeric AND pdv_vd.st_vd = 0::numeric
			UNION ALL
			 SELECT pdv_vd.cd_emp,
				pdv_vd.cd_filial,
				pdv_vd.cd_cx,
				pdv_vd.cd_vd,
				pdv_vd.cd_mov,
				pdv_vd.dt_vd,
				'CF'::text AS id_documento,
				'CHEQUES'::text AS ds_meio_pgto,
				pdv_vd.vlr_chqs AS vlr_pag,
				0 AS cod_bandeira,
				''::text AS cod_modalidade,
				0 AS cd_adm_cartao,
				1 AS tp_forma_pgto
			   FROM pdv_vd
			  WHERE pdv_vd.vlr_chqs > 0::numeric AND pdv_vd.st_vd = 0::numeric
			UNION ALL
			 SELECT pdv_vd.cd_emp,
				pdv_vd.cd_filial,
				pdv_vd.cd_cx,
				pdv_vd.cd_vd,
				pdv_vd.cd_mov,
				pdv_vd.dt_vd,
				'CF'::text AS id_documento,
					CASE
						WHEN substr(pdv_vd_tef.cod_modalidade::text, 1, 2) = '01'::text THEN 'CARTAO DEBITO'::text
						ELSE
						CASE
							WHEN substr(pdv_vd_tef.cod_modalidade::text, 1, 2) = '02'::text THEN 'CARTAO CREDITO'::text
							ELSE
							CASE
								WHEN substr(pdv_vd_tef.cod_modalidade::text, 1, 2) = '07'::text THEN 'PIX'::text
								ELSE
								CASE
									WHEN pdv_vd_tef.cod_modalidade IS NULL THEN
									CASE
										WHEN substr(pdv_vd.cod_modalidade::text, 1, 2) = '01'::text THEN 'CARTAO DEBITO'::text
										ELSE
										CASE
	WHEN substr(pdv_vd.cod_modalidade::text, 1, 2) = '02'::text THEN 'CARTAO CREDITO'::text
	ELSE 'CREDIARIO'::text
										END
									END
									ELSE 'CREDIARIO'::text
								END
							END
						END
					END AS ds_meio_pgto,
				COALESCE(pdv_vd_tef.vl_cartao, pdv_vd.vlr_cartao, pdv_vd_tef.vl_cartao) AS vlr_pag,
				pdv_vd_tef.cod_bandeira,
				pdv_vd_tef.cod_modalidade,
				pdv_vd_tef.cd_adm_cartao,
				3 AS tp_forma_pgto
			   FROM pdv_vd
				 LEFT JOIN pdv_vd_tef ON pdv_vd.cd_emp = pdv_vd_tef.cd_emp AND pdv_vd.cd_filial = pdv_vd_tef.cd_filial AND pdv_vd.cd_vd = pdv_vd_tef.cd_vd
			  WHERE pdv_vd.vlr_cartao > 0::numeric AND pdv_vd.st_vd = 0::numeric AND pdv_vd.qt_parc_cred = 0 AND COALESCE(pdv_vd_tef.vl_cartao, pdv_vd.vlr_cartao, pdv_vd_tef.vl_cartao) > 0::numeric
			UNION ALL
			 SELECT pdv_vd.cd_emp,
				pdv_vd.cd_filial,
				pdv_vd.cd_cx,
				pdv_vd.cd_vd,
				pdv_vd.cd_mov,
				pdv_vd.dt_vd,
				'CF'::text AS id_documento,
				'CREDIARIO'::text AS ds_meio_pgto,
				pdv_vd_tef.vl_cartao AS vlr_pag,
				pdv_vd_tef.cod_bandeira,
				pdv_vd_tef.cod_modalidade,
				pdv_vd_tef.cd_adm_cartao,
				5 AS tp_forma_pgto
			   FROM pdv_vd
				 JOIN pdv_vd_tef ON pdv_vd.cd_emp = pdv_vd_tef.cd_emp AND pdv_vd.cd_filial = pdv_vd_tef.cd_filial AND pdv_vd.cd_vd = pdv_vd_tef.cd_vd
			  WHERE pdv_vd.vlr_cartao > 0::numeric AND pdv_vd.st_vd = 0::numeric AND pdv_vd.qt_parc_cred > 0
			UNION ALL
			 SELECT pdv_vd.cd_emp,
				pdv_vd.cd_filial,
				pdv_vd.cd_cx,
				pdv_vd.cd_vd,
				pdv_vd.cd_mov,
				pdv_vd.dt_vd,
				'CF'::text AS id_documento,
				'VALE COMPRA'::text AS ds_meio_pgto,
				pdv_vd.vlr_tickets AS vlr_pag,
				0 AS cod_bandeira,
				''::text AS cod_modalidade,
				0 AS cd_adm_cartao,
				6 AS tp_forma_pgto
			   FROM pdv_vd
			  WHERE pdv_vd.vlr_tickets > 0::numeric AND pdv_vd.st_vd = 0::numeric
			UNION ALL
			 SELECT pdv_vd.cd_emp,
				pdv_vd.cd_filial,
				pdv_vd.cd_cx,
				pdv_vd.cd_vd,
				pdv_vd.cd_mov,
				pdv_vd.dt_vd,
				'CF'::text AS id_documento,
				'CONVENIO'::text AS ds_meio_pgto,
				COALESCE(pdv_vd.vlr_conv, 0::numeric) + COALESCE(pdv_vd.vlr_conv_pbm, 0::numeric) AS vlr_pag,
				0 AS cod_bandeira,
				''::text AS cod_modalidade,
				0 AS cd_adm_cartao,
				4 AS tp_forma_pgto
			   FROM pdv_vd
			  WHERE (COALESCE(pdv_vd.vlr_conv, 0::numeric) + COALESCE(pdv_vd.vlr_conv_pbm, 0::numeric)) > 0::numeric AND pdv_vd.st_vd = 0::numeric
			UNION ALL
			 SELECT pdv_vd.cd_emp,
				pdv_vd.cd_filial,
				pdv_vd.cd_cx,
				pdv_vd.cd_vd,
				pdv_vd.cd_mov,
				pdv_vd.dt_vd,
				'CF'::text AS id_documento,
				'DUPLICATA'::text AS ds_meio_pgto,
				pdv_vd.vlr_dup AS vlr_pag,
				0 AS cod_bandeira,
				''::text AS cod_modalidade,
				0 AS cd_adm_cartao,
				7 AS tp_forma_pgto
			   FROM pdv_vd
			  WHERE pdv_vd.vlr_dup > 0::numeric AND pdv_vd.st_vd = 0::numeric
			UNION ALL
			 SELECT pdv_vd.cd_emp,
				pdv_vd.cd_filial,
				pdv_vd.cd_cx,
				pdv_vd.cd_vd,
				pdv_vd.cd_mov,
				pdv_vd.dt_vd,
				'CF'::text AS id_documento,
				'NCC'::text AS ds_meio_pgto,
				pdv_vd.vlr_ncc AS vlr_pag,
				0 AS cod_bandeira,
				''::text AS cod_modalidade,
				0 AS cd_adm_cartao,
				8 AS tp_forma_pgto
			   FROM pdv_vd
			  WHERE pdv_vd.vlr_ncc > 0::numeric AND pdv_vd.st_vd = 0::numeric
			UNION ALL
			 SELECT rec_n_fisc.cd_emp,
				rec_n_fisc.cd_filial,
				rec_n_fisc.cd_cx,
				rec_n_fisc.cd_ctr AS cd_vd,
				rec_n_fisc.cd_mov,
				rec_n_fisc.dt_cupom AS dt_vd,
				'CNF'::text AS id_documento,
				pgtos.ds_meio_pgto,
				sum(pgtos.vlr_forma_pagto) AS vlr_pag,
				0 AS cod_bandeira,
				''::text AS cod_modalidade,
				0 AS cd_adm_cartao,
				pgtos.tp_forma_pgto
			   FROM pdv_cupom_nao_fiscal rec_n_fisc
				 JOIN v_pdv_cupom_nao_fiscal_forma_pgtos_fecha_caixa pgtos ON rec_n_fisc.cd_emp = pgtos.cd_emp AND rec_n_fisc.cd_filial = pgtos.cd_filial AND rec_n_fisc.cd_cx = pgtos.cd_cx AND rec_n_fisc.cd_ctr = pgtos.cd_ctr AND rec_n_fisc.cd_mov = pgtos.cd_mov
			  WHERE rec_n_fisc.st_cupom = 0::numeric AND (rec_n_fisc.tp_cupom_nao_fiscal = ANY (ARRAY[0::numeric, 1::numeric, 2::numeric, 3::numeric, 4::numeric, 7::numeric]))
			  GROUP BY rec_n_fisc.cd_emp, rec_n_fisc.cd_filial, rec_n_fisc.cd_cx, rec_n_fisc.cd_ctr, rec_n_fisc.cd_mov, rec_n_fisc.dt_cupom, pgtos.ds_meio_pgto, pgtos.tp_forma_pgto
			UNION ALL
			 SELECT rec_n_fisc.cd_emp,
				rec_n_fisc.cd_filial,
				rec_n_fisc.cd_cx,
				rec_n_fisc.cd_ctr AS cd_vd,
				rec_n_fisc.cd_mov,
				rec_n_fisc.dt_cupom AS dt_vd,
				'CNF'::text AS id_documento,
				pgtos.ds_meio_pgto,
				sum(pgtos.vlr_forma_pagto * '-1'::integer::numeric) AS vlr_pag,
				0 AS cod_bandeira,
				''::text AS cod_modalidade,
				0 AS cd_adm_cartao,
				pgtos.tp_forma_pgto
			   FROM pdv_cupom_nao_fiscal rec_n_fisc
				 JOIN v_pdv_cupom_nao_fiscal_forma_pgtos_fecha_caixa pgtos ON rec_n_fisc.cd_emp = pgtos.cd_emp AND rec_n_fisc.cd_filial = pgtos.cd_filial AND rec_n_fisc.cd_cx = pgtos.cd_cx AND rec_n_fisc.cd_ctr = pgtos.cd_ctr AND rec_n_fisc.cd_mov = pgtos.cd_mov
			  WHERE rec_n_fisc.st_cupom = 0::numeric AND rec_n_fisc.tp_cupom_nao_fiscal = 5::numeric
			  GROUP BY rec_n_fisc.cd_emp, rec_n_fisc.cd_filial, rec_n_fisc.cd_cx, rec_n_fisc.cd_ctr, rec_n_fisc.cd_mov, rec_n_fisc.dt_cupom, pgtos.ds_meio_pgto, pgtos.tp_forma_pgto) rstemp
	  GROUP BY rstemp.dt_vd, rstemp.ds_meio_pgto, rstemp.id_documento, rstemp.cd_emp, rstemp.cd_filial, rstemp.cd_cx, rstemp.cd_mov, rstemp.cod_bandeira, rstemp.cod_modalidade, rstemp.cd_adm_cartao, rstemp.tp_forma_pgto
	  ORDER BY rstemp.dt_vd, rstemp.ds_meio_pgto;

	-- Permissions

	ALTER TABLE public.v_pdv_meios_pgto_fecha_caixa OWNER TO postgres;
	
	RAISE NOTICE 'v_pdv_meios_pgto_fecha_caixa Recriada.';

END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION addView() OWNER TO postgres; 
SELECT addView(); 
DROP FUNCTION addView();


CREATE OR REPLACE FUNCTION addView() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
	
	IF EXISTS (SELECT 1 FROM information_schema.columns 
					WHERE table_name= 'v_pdv_tef_pendentes') THEN 
		DROP VIEW v_pdv_tef_pendentes;
		RAISE NOTICE 'v_pdv_tef_pendentes';
	END IF;
	
	CREATE OR REPLACE VIEW public.v_pdv_tef_pendentes
	AS SELECT 0 AS tp_cupom,
		pdv_vd_tef.cd_emp,
		pdv_vd_tef.cd_filial,
		vd.cd_cx,
		pdv_vd_tef.cd_vd,
		pdv_vd_tef.cd_trn_tef,
		pdv_vd_tef.cd_adm_cartao,
		pdv_vd_tef.nr_autorizacao,
		pdv_vd_tef.cod_rede,
		pdv_vd_tef.cod_modalidade,
		pdv_vd_tef.cod_bandeira,
		pdv_vd_tef.vl_cartao,
		pdv_vd_tef.nsu_tef,
		pdv_vd_tef.vl_saque_cartao,
		pdv_vd_tef.trn_pos,
		pdv_vd_tef.gerenciador_tef,
		pdv_vd_tef.tp_adm,
		pdv_vd_tef.qt_parc,
		pdv_vd_tef.ds_bandeira,
		pdv_vd_tef.nr_comprovante,
		pdv_vd_tef.nr_estabelecimento,
		pdv_vd_tef.tipo_transacao,
		pdv_vd_tef.st_transacao,
		pdv_vd_tef.retorno_tef,
		pdv_vd_tef.sts_imp_comp,
		pdv_vd_tef.obs,
		pdv_vd_tef.nr_controle_transacao,
		pdv_vd_tef.dt_transacao,
		pdv_vd_tef.hr_transacao,
		0 AS tp_cupom_nao_fiscal,
		pdv_vd_tef.ds_forma_pag_qr_linx
	   FROM pdv_vd vd
		 JOIN pdv_vd_tef ON vd.cd_emp = pdv_vd_tef.cd_emp AND vd.cd_filial = pdv_vd_tef.cd_filial AND vd.cd_vd = pdv_vd_tef.cd_vd
	UNION ALL
	 SELECT 1 AS tp_cupom,
		cnf_tef.cd_emp,
		cnf_tef.cd_filial,
		cnf_tef.cd_cx,
		cnf_tef.cd_ctr AS cd_vd,
		cnf_tef.cd_trn_tef,
		cnf_tef.cd_adm_cartao,
		cnf_tef.nr_autorizacao,
		cnf_tef.cod_rede,
		cnf_tef.cod_modalidade,
		cnf_tef.cod_bandeira,
		cnf_tef.vl_cartao,
		cnf_tef.nsu_tef,
		cnf_tef.vl_saque_cartao,
		cnf_tef.trn_pos,
		cnf_tef.gerenciador_tef,
		cnf_tef.tp_adm,
		cnf_tef.qt_parc,
		cnf_tef.ds_bandeira,
		cnf_tef.nr_comprovante,
		cnf_tef.nr_estabelecimento,
		cnf_tef.tipo_transacao,
		cnf_tef.st_transacao,
		cnf_tef.retorno_tef,
		cnf_tef.sts_imp_comp,
		cnf_tef.obs,
		cnf_tef.nr_controle_transacao,
		cnf_tef.dt_transacao,
		cnf_tef.hr_transacao,
		cnf.tp_cupom_nao_fiscal,
		cnf_tef.ds_forma_pag_qr_linx
	   FROM pdv_cupom_nao_fiscal cnf
		 JOIN pdv_cupom_nao_fiscal_tef cnf_tef ON cnf.cd_emp = cnf_tef.cd_emp AND cnf.cd_filial = cnf_tef.cd_filial AND cnf.cd_cx = cnf_tef.cd_cx AND cnf.cd_ctr = cnf_tef.cd_ctr;

	-- Permissions

	ALTER TABLE public.v_pdv_tef_pendentes OWNER TO postgres;
	
	RAISE NOTICE 'v_pdv_tef_pendentes Recriada.';

END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION addView() OWNER TO postgres; 
SELECT addView(); 
DROP FUNCTION addView();


CREATE OR REPLACE FUNCTION addView() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
	
	IF EXISTS (SELECT 1 FROM information_schema.columns 
					WHERE table_name= 'v_recebimento_crediario') THEN 
		DROP VIEW v_recebimento_crediario;
		RAISE NOTICE 'v_recebimento_crediario';
	END IF;
	
	CREATE OR REPLACE VIEW public.v_recebimento_crediario
	AS SELECT cupom.cd_emp,
		cupom.cd_filial,
		cupom.cd_cx,
		cupom.dt_cupom,
		cupom.dt_cad,
		cupom.dt_cad AS hr_cupom,
		cupom.tp_cupom_nao_fiscal AS tp_cupom,
		fatura.nrfatura,
		fatura.dt_vencto,
		fatura.cd_ctr_pgto,
		0 AS cd_ctr_pgto_parcela,
		cupom.cd_mov,
		cupom.cd_ctr,
		cupom.nr_coo,
		cupom.st_cupom,
		cupom.cont_cupom_fisc AS contador_cupom_fiscal,
		cupom.cd_mov AS codigo_movimento,
		cupom.vlr_to_cupom AS vlr_tot_cupom,
		cupom.vlr_dinh,
		cupom.vlr_cartao,
		cupom.vlr_chqs_a_vista + cupom.vlr_chqs_a_prz AS vlr_chqs,
		cupom.nr_serie_imp AS nr_serie_ecf,
		cupom.vs_pdv AS versao_pdv,
		cupom.vs_pdv_rc AS versao_pdv_rc,
		NULLIF(COALESCE(cupom.vlr_dinh, 0::numeric) <> 0::numeric, false) AS contem_dinheiro,
		NULLIF(cupom.st_cupom <> 0::numeric, false) AS is_cancelado,
		cupom.tp_cupom_nao_fiscal = 0::numeric AS is_fatura,
		cupom.cd_ctr AS doacao_id,
		COALESCE(fatura.cd_ctr_pgto) AS fatura_rec_id,
		fatura.cd_rc_deb AS fatura_id,
		fatura.vlr_sld_dp AS fatura_vlr,
		fatura.vlr_min_pgto AS fatura_vlr_min,
		fatura.vlr_pago AS fatura_vlr_cred,
		fatura.vlrdesconto AS vlr_desc,
		fatura.vlrjuros,
		fatura.vlr_origin_fatura AS vlr_original,
		0 AS parcela_id,
		0 AS parcela_vlr,
		0 AS parcela_vlr_cred,
		0 AS st_vd,
		cupom.hash_protocolo,
		cupom.st_pend_estorno,
		fatura.tp_pgto_offline,
		0 AS tp_pgto_offline_parcela,
		fatura.filial_origem,
		fatura.dt_lancto,
		fatura.nrdoc,
		fatura.cd_rc_deb,
		fatura.vlr_pago,
		0 AS vlr_pago_parc,
		cupom.cd_usu,
		0 AS tp_reg,
		cupom.cd_cli,
		cupom.vlr_troco 
	   FROM pdv_cupom_nao_fiscal_rec_fatura fatura
		 JOIN pdv_cupom_nao_fiscal cupom ON fatura.cd_emp = cupom.cd_emp AND fatura.cd_filial = cupom.cd_filial AND fatura.cd_cx = cupom.cd_cx AND fatura.cd_ctr = cupom.cd_ctr
	UNION
	 SELECT cupom.cd_emp,
		cupom.cd_filial,
		cupom.cd_cx,
		cupom.dt_cupom,
		cupom.dt_cad,
		cupom.dt_cad AS hr_cupom,
		cupom.tp_cupom_nao_fiscal AS tp_cupom,
		'0'::character varying AS nrfatura,
		( SELECT now() AS now) AS dt_vencto,
		0 AS cd_ctr_pgto,
		parcela.cd_ctr_pgto AS cd_ctr_pgto_parcela,
		cupom.cd_mov,
		cupom.cd_ctr,
		cupom.nr_coo,
		cupom.st_cupom,
		cupom.cont_cupom_fisc AS contador_cupom_fiscal,
		cupom.cd_mov AS codigo_movimento,
		cupom.vlr_to_cupom AS vlr_tot_cupom,
		cupom.vlr_dinh,
		cupom.vlr_cartao,
		cupom.vlr_chqs_a_vista + cupom.vlr_chqs_a_prz AS vlr_chqs,
		cupom.nr_serie_imp AS nr_serie_ecf,
		cupom.vs_pdv AS versao_pdv,
		cupom.vs_pdv_rc AS versao_pdv_rc,
		NULLIF(COALESCE(cupom.vlr_dinh, 0::numeric) <> 0::numeric, false) AS contem_dinheiro,
		NULLIF(cupom.st_cupom <> 0::numeric, false) AS is_cancelado,
		cupom.tp_cupom_nao_fiscal = 0::numeric AS is_fatura,
		cupom.cd_ctr AS doacao_id,
		COALESCE(parcela.cd_ctr_pgto) AS fatura_rec_id,
		0 AS fatura_id,
		0 AS fatura_vlr,
		0 AS fatura_vlr_min,
		0 AS fatura_vlr_cred,
		0 AS vlr_desc,
		0 AS vlrjuros,
		0 AS vlr_original,
		parcela.cd_ctr_parc AS parcela_id,
		parcela.vlr_parc AS parcela_vlr,
		parcela.vlr_pago AS parcela_vlr_cred,
		0 AS st_vd,
		cupom.hash_protocolo,
		cupom.st_pend_estorno,
		0 AS tp_pgto_offline,
		parcela.tp_pgto_offline AS tp_pgto_offline_parcela,
		0 AS filial_origem,
		( SELECT now() AS now) AS dt_lancto,
		''::character varying AS nrdoc,
		0 AS cd_rc_deb,
		0 AS vlr_pago,
		parcela.vlr_pago AS vlr_pago_parc,
		cupom.cd_usu,
		1 AS tp_reg,
		cupom.cd_cli,
		cupom.vlr_troco
	   FROM pdv_cupom_nao_fiscal_rec_parc_cred parcela
		 JOIN pdv_cupom_nao_fiscal cupom ON parcela.cd_emp = cupom.cd_emp AND parcela.cd_filial = cupom.cd_filial AND parcela.cd_cx = cupom.cd_cx AND parcela.cd_ctr = cupom.cd_ctr;

	-- Permissions

	ALTER TABLE public.v_recebimento_crediario OWNER TO postgres;
	
	RAISE NOTICE 'v_recebimento_crediario Recriada.';

END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION addView() OWNER TO postgres; 
SELECT addView(); 
DROP FUNCTION addView();